#ifndef NAGF16
#define NAGF16

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC


#ifdef __cplusplus
extern "C"
{
#endif
//Cheney change Complex to complex
void NAG_CALL f16dbc(Integer n, Integer alpha, Integer x[], Integer incx, NagError *fail);

void NAG_CALL f16fbc(Integer n, double alpha, double x[], Integer incx, NagError *fail);

void NAG_CALL f16ecc( Integer n, double alpha, const double x[], Integer incx, double beta, double y[], Integer incy, NagError *fail );

void NAG_CALL f16hbc(Integer n, complex &alpha, complex x[], Integer incx, NagError *fail);

void NAG_CALL f16pac( Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, double alpha, const double *a, Integer pda, const double *x, Integer incx, double beta, double *y, Integer incy, NagError *fail );

void NAG_CALL f16pbc( Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, Integer kl, Integer ku, double alpha, const double *ab, Integer pdab, const double *x, Integer incx, double beta, double *y, Integer incy, NagError *fail );

void NAG_CALL f16pcc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const double *a, Integer pda, const double *x, Integer incx, double beta, double *y, Integer incy, NagError *fail );

void NAG_CALL f16pdc( Nag_OrderType order, Nag_UploType uplo, Integer n, Integer k, double alpha, const double *a, Integer pda, const double *x, Integer incx, double beta, double *y, Integer incy, NagError *fail );

void NAG_CALL f16pec( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const double *ap, const double *x, Integer incx, double beta, double *y, Integer incy, NagError *fail );

void NAG_CALL f16pfc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, double alpha, const double *t, Integer pdt, double *x, Integer incx, NagError *fail );

void NAG_CALL f16pgc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer k, double alpha, const double *t, Integer pdt, double *x, Integer incx, NagError *fail );

void NAG_CALL f16phc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, double alpha, const double *tp, double *x, Integer incx, NagError *fail );

void NAG_CALL f16pjc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, double alpha, const double *t, Integer pdt, double *x, Integer incx, NagError *fail );

void NAG_CALL f16pkc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer k, double alpha, const double *t, Integer pdt, double *x, Integer incx, NagError *fail );

void NAG_CALL f16plc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, double alpha, const double *tp, double *x, Integer incx, NagError *fail );

void NAG_CALL f16pmc( Nag_OrderType order, Nag_ConjType conj, Integer m, Integer n, double alpha, const double *x, Integer incx, const double *y, Integer incy, double beta, double *a, Integer pda, NagError *fail );

void NAG_CALL f16ppc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const double *x, Integer incx, double beta, double *a, Integer pda, NagError *fail );

void NAG_CALL f16pqc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const double *x, Integer incx, double beta, double *ap, NagError *fail );

void NAG_CALL f16prc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const double *x, Integer incx, const double *y, Integer incy, double beta, double *a, Integer pda, NagError *fail );

void NAG_CALL f16psc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const double *x, Integer incx, const double *y, Integer incy, double beta, double *ap, NagError *fail );

void NAG_CALL f16sac( Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, complex &alpha, const complex *a, Integer pda, const complex *x, Integer incx, complex &beta, complex *y, Integer incy, NagError *fail );

void NAG_CALL f16sbc( Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, Integer kl, Integer ku, complex &alpha, const complex *ab, Integer pdab, const complex *x, Integer incx, complex &beta, complex *y, Integer incy, NagError *fail );

void NAG_CALL f16scc( Nag_OrderType order, Nag_UploType uplo, Integer n, complex &alpha, const complex *a, Integer pda, const complex *x, Integer incx, complex &beta, complex *y, Integer incy, NagError *fail );

void NAG_CALL f16sdc( Nag_OrderType order, Nag_UploType uplo, Integer n, Integer k, complex &alpha, const complex *a, Integer pda, const complex *x, Integer incx, complex &beta, complex *y, Integer incy, NagError *fail );

void NAG_CALL f16sec( Nag_OrderType order, Nag_UploType uplo, Integer n, complex &alpha, const complex *ap, const complex *x, Integer incx, complex &beta, complex y[], Integer incy, NagError *fail );

void NAG_CALL f16sfc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, complex &alpha, const complex *t, Integer pdt, complex *x, Integer incx, NagError *fail );

void NAG_CALL f16sgc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer k, complex &alpha, const complex *t, Integer pdt, complex *x, Integer incx, NagError *fail );

void NAG_CALL f16shc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, complex &alpha, const complex *tp, complex *x, Integer incx, NagError *fail );

void NAG_CALL f16sjc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, complex &alpha, const complex *t, Integer pdt, complex *x, Integer incx, NagError *fail );

void NAG_CALL f16skc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, Integer k, complex &alpha, const complex *t, Integer pdt, complex *x, Integer incx, NagError *fail );

void NAG_CALL f16slc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, complex &alpha, const complex *tp, complex *x, Integer incx, NagError *fail );

void NAG_CALL f16smc( Nag_OrderType order, Nag_ConjType conj, Integer m, Integer n, complex &alpha, const complex x[], Integer incx, const complex y[], Integer incy, complex &beta, complex a[], Integer pda, NagError *fail );

void NAG_CALL f16spc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const complex *x, Integer incx, double beta, complex *a, Integer pda, NagError *fail );

void NAG_CALL f16src( Nag_OrderType order, Nag_UploType uplo, Integer n, complex &alpha, const complex *x, Integer incx, const complex *y, Integer incy, double beta, complex *a, Integer pda, NagError *fail );

void NAG_CALL f16sqc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, const complex *x, Integer incx, double beta, complex *ap, NagError *fail );

void NAG_CALL f16ssc( Nag_OrderType order, Nag_UploType uplo, Integer n, complex &alpha, const complex *x, Integer incx, const complex *y, Integer incy, double beta, complex *ap, NagError *fail );

void NAG_CALL f16yac( Nag_OrderType order, Nag_TransType transa, Nag_TransType transb, Integer m, Integer n, Integer k, double alpha, const double *a, Integer pda, const double *b, Integer pdb, double beta, double *c, Integer pdc, NagError *fail );

void NAG_CALL f16ycc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Integer m, Integer n, double alpha, const double *a, Integer pda, const double *b, Integer pdb, double beta, double *c, Integer pdc, NagError *fail );

void NAG_CALL f16yfc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType transt, Nag_DiagType diag, Integer m, Integer n, double alpha, const double *t, Integer pdt, double *b, Integer pdb, NagError *fail );

void NAG_CALL f16yjc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType transt, Nag_DiagType diag, Integer m, Integer n, double alpha, const double t[], Integer pdt, double b[], Integer pdb, NagError *fail );

void NAG_CALL f16ypc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Integer n, Integer k, double alpha, const double *a, Integer pda, double beta, double *c, Integer pdc, NagError *fail );

void NAG_CALL f16yrc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Integer n, Integer k, double alpha, const double *a, Integer pda, const double *b, Integer pdb, double beta, double *c, Integer pdc, NagError *fail );

void NAG_CALL f16zac( Nag_OrderType order, Nag_TransType transa, Nag_TransType transb, Integer m, Integer n, Integer k, complex &alpha, const complex *a, Integer pda, const complex *b, Integer pdb, complex &beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16zcc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Integer m, Integer n, complex &alpha, const complex *a, Integer pda, const complex *b, Integer pdb, complex &beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16zfc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType transt, Nag_DiagType diag, Integer m, Integer n, complex &alpha, const complex *t, Integer pdt, complex *b, Integer pdb, NagError *fail );

void NAG_CALL f16zjc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Nag_TransType transt, Nag_DiagType diag, Integer m, Integer n, complex &alpha, const complex *t, Integer pdt, complex *b, Integer pdb, NagError *fail );

void NAG_CALL f16zpc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Integer n, Integer k, double alpha, const complex *a, Integer pda, double beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16zrc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Integer n, Integer k, complex &alpha, const complex *a, Integer pda, const complex *b, Integer pdb, double beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16ztc( Nag_OrderType order, Nag_SideType side, Nag_UploType uplo, Integer m, Integer n, complex &alpha, const complex *a, Integer pda, const complex *b, Integer pdb, complex &beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16zuc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Integer n, Integer k, complex &alpha, const complex *a, Integer pda, complex &beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16zwc( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Integer n, Integer k, complex &alpha, const complex *a, Integer pda, const complex *b, Integer pdb, complex &beta, complex *c, Integer pdc, NagError *fail );

void NAG_CALL f16qec( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, const double a[], Integer pda, double b[], Integer pdb, NagError *fail );

void NAG_CALL f16qfc( Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, const double a[], Integer pda, double b[], Integer pdb, NagError *fail );

void NAG_CALL f16qgc( Nag_OrderType order, Nag_UploType uplo, Integer n, double alpha, double diag, double a[], Integer pda, NagError *fail);

void NAG_CALL f16qhc( Nag_OrderType order, Integer m, Integer n, double alpha, double diag, double a[], Integer pda, NagError *fail);

void NAG_CALL f16rac( Nag_OrderType order, Nag_NormType norm, Integer m, Integer n, const double a[], Integer pda, double *r, NagError *fail );

void NAG_CALL f16rbc( Nag_OrderType order, Nag_NormType norm, Integer m, Integer n, Integer kl, Integer ku, const double ab[], Integer pdab, double *r, NagError *fail );

void NAG_CALL f16rcc( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, const double a[], Integer pda, double *r, NagError *fail );

void NAG_CALL f16rdc( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, const double ap[], double *r, NagError *fail );

void NAG_CALL f16rec( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, Integer k, const double ab[], Integer pdab, double *r, NagError *fail );

void NAG_CALL f16tec( Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, Nag_DiagType diag, Integer n, const complex a[], Integer pda, complex b[], Integer pdb, NagError *fail );

void NAG_CALL f16tfc( Nag_OrderType order, Nag_TransType trans, Integer m, Integer n, const complex a[], Integer pda, complex b[], Integer pdb, NagError *fail );

void NAG_CALL f16tgc( Nag_OrderType order, Nag_UploType uplo, Integer n, complex &alpha, complex diag, complex a[], Integer pda, NagError *fail);

void NAG_CALL f16thc( Nag_OrderType order, Integer m, Integer n, complex &alpha, complex &diag, complex a[], Integer pda, NagError *fail);

void NAG_CALL f16uac( Nag_OrderType order, Nag_NormType norm, Integer m, Integer n, const complex a[], Integer pda, double *r, NagError *fail );

void NAG_CALL f16ubc( Nag_OrderType order, Nag_NormType norm, Integer m, Integer n, Integer kl, Integer ku, const complex ab[], Integer pdab, double *r, NagError *fail );

void NAG_CALL f16ucc( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, const complex a[], Integer pda, double *r, NagError *fail );

void NAG_CALL f16udc( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, const complex ap[], double *r, NagError *fail );

void NAG_CALL f16uec( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, Integer k, const complex ab[], Integer pdab, double *r, NagError *fail );

void NAG_CALL f16ufc( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, const complex a[], Integer pda, double *r, NagError *fail );

void NAG_CALL f16ugc( Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, Integer n, const complex ap[], double *r, NagError *fail );

  /* Utilities to form complex conjugate of a vector */

void f16gex(Integer m, complex *x, Integer incx);
void f16gey(Integer m, const complex *x, complex *xbar, Integer incx);

#ifdef __cplusplus
}
#endif
#endif /* not NAGF16 */
